//%attributes = {"publishedSql":true}
// Method: _rem_ CONNECTION_TCP(kOpen | kClose | kRemove)
// 2004.03.19-02:44:50 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// see: _rem_ CONNECTION
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($1; $_rem_lPrevSocket; $_rem_lSocketIndex)
C_TEXT:C284($_rem_tReply)

Case of 
	: ($1=kOpen)  //open socket if not already opened
		_tcp_ RECEIVE_DELAY_SET(<>_rem_rBindPrsDelay1Time; <>_rem_lBindPrsDelay; <>_rem_lBindPrsDelay2)
		
		$_rem_lPrevSocket:=_rem_lSocket
		_rem_lSocket:=_tcp_ ConnectionOpen(_rem_tIpAddress; _rem_lPortNum; _rem_lSocket; _rem_tSocketOptions)
		If (($_rem_lPrevSocket#_rem_lSocket) & (_rem_lSocket#0))
			_rem_LOG_SET("Connection opened, socket: "+String:C10(_rem_lSocket))
			_db_ CONNECTED_SET(kTrue)
		End if 
		
		// add zmq socket to server socket array
		$_rem_lSocketIndex:=_tcp_ ServerSocketAdd(0; _rem_lSocket)  // adds only to arrays
		If ($_rem_lSocketIndex>0)
			<>_tcp_alSocketType{$_rem_lSocketIndex}:=1  // 1=tcp, 2=zmq, 3=ops
			$_rem_tLocalAddress:=_tcp_ LocalAddressGet(_rem_lSocket)
			<>_tcp_alSocketLocalPort{$_rem_lSocketIndex}:=Num:C11(_str LastPart($_rem_tLocalAddress; ":"))
			//<>_tcp_alSocketLocalPort{$_rem_lSocketIndex}:=_rem_lPortNum
			<>_tcp_atSocketId{$_rem_lSocketIndex}:="tcp"
			<>_tcp_alSocketStatus{$_rem_lSocketIndex}:=_tcp_ StatusGet(_rem_lSocket)
			<>_tcp_alSocketRequestPrs{$_rem_lSocketIndex}:=Current process:C322
		End if 
		
	: ($1=kClose)  //set to unactive mode
		_trace
		_tcp_ CONNECTION_CLOSE(_rem_lSocket)
		_rem_lSocket:=0
		
	: ($1=kRemove)  //really close socket
		If (_rem_lSocket#0)
			If (_tcp_ StatusGet(_rem_lSocket)=8)
				Case of 
					: (_rem_tRequestMethod="err_@")
						IDLE:C311
					: (_rem_tRequest="err_@")  //err_not_started, err_timeout and so on...
						IDLE:C311
					: (_rem_tErr="err_@")  //err_not_started, err_timeout and so on...
						IDLE:C311
					Else 
						_rem_ CALL_SET("_rem_Quit")
						_rem_ PARAM_TEXT_SET("do quit")
						_rem_ CALL(Current method name:C684)
						If (_rem_ LastError=0)
							If (_rem_ RemotePrsIs(Current process:C322)=kFalse)  // server quitting can not wait for answer
								$_rem_tReply:=_rem_ ParamTextGet
							End if 
						End if 
				End case 
			End if 
			_tcp_ CONNECTION_CLOSE(_rem_lSocket)
		End if 
		_rem_LOG_SET("Connection removed, socket: "+String:C10(_rem_lSocket))
		_rem_lSocket:=0
		_rem_lBindPrsNum:=0
		_rem_tUuid:=""
		_rem_tUuidReceived:=""
		
		If (_db_ lConnected=kTrue)
			_db_ CONNECTED_SET(kFalse)  //to prevent recursive call in _db_ DATABASE_SET ("")
		End if 
		//_db_ DATABASE_SET ("-")  // set to prev database, don't do it here?
		
	Else 
		_err MESSAGE_PARAMETER("$1"; Current method name:C684; kFalse)
End case 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 